using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Printing;
using System.IO;

namespace Recipe_1._3
{
    public partial class FormMain : Form
    {
        /// <summary>
        /// Constructor: called when object is created, you generally do *not* modify this method.
        /// </summary>
        public FormMain()
        {
            InitializeComponent();
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
            // TODO: This line of code loads data into the 'itemsDatabaseDataSet.Items_Table' table. You can move, or remove it, as needed.
            this.items_TableTableAdapter.Fill(this.itemsDatabaseDataSet.Items_Table);

        }

        private void helpToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FormAboutBox frm;
            frm = new FormAboutBox();  // create an instance of the About Box
            frm.ShowDialog();          // Show it as a dialog (user must dismiss before continuing)
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void addToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FormAdd frm;
            DialogResult result;
            //
            // Create and show form to user for adding new item:
            //
            frm = new FormAdd();
            result = frm.ShowDialog();
            //
            // Did user cancel, or click ok?
            //
            if (result == System.Windows.Forms.DialogResult.Cancel)
                MessageBox.Show("Add cancelled...", "Cook Book", MessageBoxButtons.OK, MessageBoxIcon.Information);
            else
            {
                //
                // user clicked ok, so add new item to the database:
                //
                string name, ingredients, directions, tips;
                byte[] image;
                //
                // (a) Retrieve item data from sub-form:
                // 
                name = frm.ItemName;
                ingredients = frm.ItemIngredients;
                directions = frm.ItemDirections;
                tips = frm.ItemTips;
                image = frm.ItemImage;
                //
                // (b) Okay, we're ready to add the new item to the database:
                //
                this.items_TableTableAdapter.Insert(name, image, directions, ingredients, tips); //descipton, image);
                //
                // (c) Now refill the dataset (our local in-memory copy):
                //
                this.items_TableTableAdapter.Fill(this.itemsDatabaseDataSet.Items_Table);

                MessageBox.Show("Item added to database!", "Cook Book", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
        }

        private void deleteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //
            // is an item selected for deletion?
            //
            if (this.lstRecipe.SelectedIndex < 0) // nothing selected, tell user to select something first:
            {
                MessageBox.Show("Please select an item for deletion...", "Cook Book", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            //
            // ok, we have a selected item, we need the item's primary key and name for deletion. Note that the primary key is
            // data-bound to the listbox's Tag property for just this purpose.
            //
            long iid;     // retrieve IID_PK from Tag (as a string), then convert to what we need (long integer)
            iid = System.Convert.ToInt64(this.lstRecipe.Tag);

            string name;  // retrieve Name_F from the Text of the selected item
            name = this.lstRecipe.Text;
            //
            // confirm deletion:
            //
            DialogResult result;
            string msg;

            msg = "Are you sure you want to delete item '" + name + "'?";
            result = MessageBox.Show(msg, "Cook Book", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
            if (result == System.Windows.Forms.DialogResult.No)  // user changed their mind, abort!
                return;
            //
            // (a) ok, go ahead and delete from underlying database:
            //
            this.items_TableTableAdapter.Delete(iid, name);
            //
            // (b) now refill the dataset (our local in-memory copy):
            //
            this.items_TableTableAdapter.Fill(this.itemsDatabaseDataSet.Items_Table);

            MessageBox.Show("Item deleted.", "Cook Book", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void editToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FormEdit frm;
            DialogResult result;
            //
            // Create and show form to user for adding new item:
            //
            frm = new FormEdit();
            result = frm.ShowDialog();
            //
            // Did user cancel, or click ok?
            //
            if (result == System.Windows.Forms.DialogResult.Cancel)
                MessageBox.Show("Edit cancelled...", "Cook Book", MessageBoxButtons.OK, MessageBoxIcon.Information);
            else
            {
                //
                // user clicked Save, so update the database:                                                
                //and refill the dataset (our local in-memory copy):
                //
                this.items_TableTableAdapter.Fill(this.itemsDatabaseDataSet.Items_Table);

                MessageBox.Show("Item Updated!", "Cook Book", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
        }
        
        /// <summary>
        /// Event fires when the Print menu item is clicked.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        /// <remarks>
        /// The Print Dialog will display to the user the standard
        /// Windows Print Dialog that we are all used to seeing.  Once
        /// again, the Print Dialog does not know how to print a document,
        /// but can deliver pertinent information to the printing process.
        /// </remarks>
        private void printMenuItem_Click(object sender, EventArgs e)
        {            
            if (printDialog1.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                printDocument1.PrintPage += new PrintPageEventHandler(printDocument1_PrintPage);
                CaptureScreen();
                printDocument1.Print();

                // IMPOTRANT!!!
                // This will print an empty document.  to print out what
                // you see in the RichTextBox, you will have to convert it
                // to an image using classes in the System.Drawing.Graphics
                // namespace.
                //
                // For a full implementation of this, see this Microsoft
                // article on MSDN:
                // http://support.microsoft.com/default.aspx?scid=kb;en-us;812425#XSLTH3132121122120121120120
            }
        }
            
        Bitmap memoryImage;

        private void CaptureScreen()
        {
            Graphics myGraphics = this.CreateGraphics();            
            Size s = this.Size;
            memoryImage = new Bitmap(s.Width, s.Height, myGraphics);
            Graphics memoryGraphics = Graphics.FromImage(memoryImage);
            memoryGraphics.CopyFromScreen(this.Location.X, this.Location.Y, 0, 0, s);            
        }

        private string formatLstRecipe(string formatString)
        {
            if (formatString.Length > 35)
            {
                int i = 35;
                int pos = 0;
                while (i < formatString.Length)
                {
                    pos = formatString.LastIndexOf(" ", i);
                    formatString = formatString.Remove(pos, 1);
                    formatString = formatString.Insert(pos, "\n");
                    i += 35;
                }
            }
            return formatString;
        }

        private string formatTxtBoxString(string formatString)
        {                               
            if (formatString.Length > 65)
            {
                int i = 0, pos = 0, needNewLine = 0;               
                while (i < formatString.Length)
                {
                    if ((formatString[i] == '\n') && (needNewLine < 65))
                    {
                        needNewLine = 0;
                    }
                    else if(needNewLine >= 65)
                    {
                        pos = formatString.LastIndexOf(" ", i);
                        formatString = formatString.Remove(pos, 1);
                        formatString = formatString.Insert(pos, "\n");                        
                        needNewLine = 0;
                    }                    
                    needNewLine++;
                    i++;
                }                
            }
            return formatString;
        }

        private void printDocument1_PrintPage(System.Object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            //if you uncomment the following line of code and delete
            //the rest you will get a print screen format of printing/previewing.
            //e.Graphics.DrawImage(memoryImage, 0, 0);
            
            //Call the formatLstRecipe() function to format the
            //Recipe name string for printing.
            string printLstRecipe = formatLstRecipe(lstRecipe.Text);

            //Call the formatTxtBoxString() function to format the
            //textbox strings for printing.
            string printTxtIngredients = formatTxtBoxString(txtIngredients.Text);
            string printTxtDirections = formatTxtBoxString(txtDirections.Text);
            string printTxtTips = formatTxtBoxString(txtTips.Text);
            printTxtIngredients = printTxtIngredients.Trim();
            printTxtDirections = printTxtDirections.Trim();
            printTxtTips = printTxtTips.Trim();
            string finalPrintString = label2.Text + "\n" + printTxtIngredients + "\n\n\n" + label3.Text + "\n" + printTxtDirections + "\n\n\n" + label4.Text + "\n" + printTxtTips;

            #region Attempt to form individuall print strings
            /*The following code was a sad attempt at building seperate string so that I
             * could output the labels individually in bold font. Unfortunatlly I couldn't
             * get the spacing to be consistant when creating the print image.
            StringBuilder buildSpaces = new StringBuilder();
            string spacesDirectionLable = buildSpaces.Append('\n', 3+(2*(txtIngredients.TextLength / 70))).ToString();            
            buildSpaces.Remove(0, buildSpaces.Length);
            
            string spacesTipLable = buildSpaces.Append('\n', 3+(2 * txtDirections.TextLength / 70)).ToString();
            buildSpaces.Remove(0, buildSpaces.Length);

            string spacesDirections = buildSpaces.Append('\n', 2 + (2 * (txtIngredients.TextLength / 70))).ToString();
            buildSpaces.Remove(0, buildSpaces.Length);
            
            string spacesTips = buildSpaces.Append('\n', 2 + (2 * (txtDirections.TextLength / 70))).ToString();
            buildSpaces.Remove(0, buildSpaces.Length);
            
            string finalPrintLables = label2.Text + spacesDirectionLable + label3.Text + spacesTipLable + label4.Text;
            string finalPrintTxtBoxes = "\n" + printTxtIngredients + spacesDirections + printTxtDirections + spacesTips + printTxtTips;
            
            e.Graphics.DrawString(finalPrintLables, txtFontBold, txtColor, txtIngredients.Location.X, label1.Location.Y);
            e.Graphics.DrawString(finalPrintTxtBoxes, txtFontRegular, txtColor, txtIngredients.Location.X, label1.Location.Y);
            */            
            #endregion

            Font txtFontRegular = new Font(Font, System.Drawing.FontStyle.Regular);
            Font txtFontBold = new Font(Font, System.Drawing.FontStyle.Bold);
            Brush txtColor = Brushes.Black;
                        
            e.Graphics.DrawString(finalPrintString, txtFontRegular, txtColor, txtIngredients.Location.X, label1.Location.Y);
            e.Graphics.DrawString(label1.Text, txtFontBold, txtColor, lstRecipe.Location.X, label1.Location.Y);
            e.Graphics.DrawString(printLstRecipe, txtFontRegular, txtColor, lstRecipe.Location.X, lstRecipe.Location.Y);
            e.Graphics.DrawString(label5.Text, txtFontRegular, txtColor, label5.Location.X, lstRecipe.Location.Y + lstRecipe.Text.Length + 50);
            if (pboxImage.Image != null)
            {
                e.Graphics.DrawImage(pboxImage.Image, pboxImage.Location.X, lstRecipe.Location.Y + lstRecipe.Text.Length + 75, pboxImage.Width, pboxImage.Height);                
            }
        }
        
        private void printPreviewMenuItem_Click(object sender, EventArgs e)
        {            
            // The print document 'myDocument' used below
            // is merely for an example.
            // You will have to specify your own print document.
            printDocument1.PrintPage += new PrintPageEventHandler(printDocument1_PrintPage);                        
            CaptureScreen();
            printPreviewDialog1.Document = printDocument1;
            printPreviewDialog1.ShowDialog();          
        }

        #region Instructions
        string InstructionsAdding = "Adding Recipes:\n On the Menu bar select File then select Add. Once the add box opens then type in the recipe information under the corresponding fields. The only required field is the recipe name. You may also add a photo of the recipe by choosing the Load Image button and then browsing to the desired photo. When you are satisfied select the add button and your recipe will be add to your Cook Book.";
        string InstructionsEditing = "Editing Recipes:\n On the Menu bar select File then select Edit. Once the edit box opens then select the recipe that you would like to edit. You can edit any part of the recipe including the name. When your are finished editing the recipe select the save button and you Cook Book will be updated.";
        string InstructionsDeleteing = "Deleting Recipes:\n In the list window select the Recipe that you wish to delete. Then on the Menu bar select File then select Delete. Your recipe will be deleted from your Cook Book";
        string InstructionsPrint = "Printing/Previewing Recipes:\n On the Menu bar select Print or Print Preview. If you select Print the recipe will be printed. If you select Print Preview a preview of what your printed reciepe will look like will open in a seperate window. You can also select to print your recipe from the Print Preview window."; 
        #endregion

        private void howToUseCookBookToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show(InstructionsAdding + "\n\n" + InstructionsEditing + "\n\n" + InstructionsDeleteing + "\n\n" + InstructionsPrint + "\n\nENJOY!!!!!");
        }
 
    }//class
}//namespace